#ifndef EUARTDef_H
#define EUARTDef_H

// this global defination is also a reference for App.

#define EUARTInterruptID_ModemStatus                0
#define EUARTInterruptID_TransmitterHoldingEmpty    1
#define EUARTInterruptID_ReceivedDataAvailable      2
#define EUARTInterruptID_LineStatus                 3
#define EUARTInterruptID_CharacterTimeout           6

#define EUARTRxFIFOTriggerLevel_1                   0
#define EUARTRxFIFOTriggerLevel_4                   1
#define EUARTRxFIFOTriggerLevel_8                   2
#define EUARTRxFIFOTriggerLevel_14                  3

#define EUARTWordLengthSelect_5                     0
#define EUARTWordLengthSelect_6                     1
#define EUARTWordLengthSelect_7                     2
#define EUARTWordLengthSelect_8                     3

#define EUARTStopBitsSelect_1                       0
#define EUARTStopBitsSelect_2or1half                1

#define EUARTParitySelect_Odd                       0
#define EUARTParitySelect_Even                      1
#define EUARTParitySelect_ForceHigh                 2
#define EUARTParitySelect_ForceLow                  3

//----
//  EUARTFIFOConfigure
//
typedef struct _EUARTFIFOConfigure
{   
    ULONG   FIFOEnable;
    ULONG   RxFIFOTriggerLevel; // EUARTRxFIFOTriggerLevel, default: 0
    
}EUARTFIFOConfigure, *PEUARTFIFOConfigure;


//----
//  EUARTGlobalStatus
//
/*typedef struct _EUARTGlobalStatus
{
    ULONG   Active;
    ULONG   SleepMode;
    ULONG   StateMachine;
    
}EUARTGlobalStatus, *PEUARTGlobalStatus;*/


//----
//  EUARTPortConfigure
//
typedef struct _EUARTPortConfigure
{
    ULONG   WordLengthSelect;   // EUARTWordLengthSelect. default: 0
    ULONG   StopBitsSelect;     // EUARTStopBitsSelect. default: 0
    ULONG   ParityEnable;       
    ULONG   ParitySelect;       // EUARTParitySelect
    
}EUARTPortConfigure, *PEUARTPortConfigure;

//----
//  BaudRate Table Entry
//
typedef struct _EUARTBaudRateEntry
{
    ULONG   BaudRate;
    
    ULONG   BRDIV;          // 0xFFFF 16bits, baud rate divider
    
}EUARTBaudRateEntry, *PEUARTBaudRateEntry;


//----
//  EUARTInterrupt
//
typedef struct _EUARTInterrupt
{
    ULONG   ReceivedDataAvailable;      // be cleard by a read to ReceiverBufferReg
    ULONG   TransmitterHoldingEmpty;    // be cleard by a read to InterruptIdentificationReg
    ULONG   LineStatus;                 // be cleard by a read to LineStatusReg
    ULONG   ModemStatus;                // be cleard by a read to ModemStatusReg
    ULONG   CharacterTimeout;           // if FIFO mode is enabled, this is enabled
                                        // be cleard by reading the RxFIFO until the RxFIFO is empty
    
}EUARTInterrupt, *PEUARTInterrupt;


//----
// EUARTLineStatus
//
typedef struct _EUARTLineStatus
{
    ULONG   DataReady;                  // R, 1bit
    ULONG   OverrunError;               // R, 1bit
    ULONG   ParityError;                // R, 1bit
    ULONG   FamingError;                // R, 1bit
    ULONG   BreakSignal;                // R, 1bit
    ULONG   TransmitterHodingEmpty;     // R, 1bit
    ULONG   TransmitterEmpty;           // R, 1bit
    ULONG   ErrorInRxFIFO;              // R, 1bit
    
}EUARTLineStatus, *PEUARTLineStatus;


//----
// EUARTModemStatus
//
typedef struct _EUARTModemStatus
{
    ULONG   CTSChange;  // R, 1bit
    ULONG   DSRChange;  // R, 1bit
    ULONG   RIChange;   // R, 1bit
    ULONG   DCDChange;  // R, 1bit
    ULONG   CTS;        // R, 1bit
    ULONG   DSR;        // R, 1bit
    ULONG   RI;         // R, 1bit
    ULONG   DCD;        // R, 1bit
    
}EUARTModemStatus, *PEUARTModemStatus;


//----
// EUARTDMAStatus
//
typedef struct _EUARTDMAStatus
{
    ULONG   TxSegmentIndication;    // R, 1bit
    ULONG   RxSegmentIndication;    // R, 1bit
    
}EUARTDMAStatus, *PEUARTDMAStatus;


//----
//  EUARTDMAInterrupt
//
typedef struct _EUARTDMAInterrupt
{
    ULONG   TxSegment;          // R/W, 1bit
    ULONG   RxSegment;          // R/W, 1bit
    ULONG   ModemStatus;        // R/W, 1bit
    ULONG   RxSegmentOverrun;   // R/W, 1bit
    ULONG   UARTOverrun;        // R/W, 1bit
    
}EUARTDMAInterrupt, *PEUARTDMAInterrupt;

//----
// _EUARTDMAInterruptStatus
//
typedef struct _EUARTDMAInterruptStatus
{   
    ULONG   TxSegment0;         // R/W1C, 1bit
    ULONG   TxSegment1;         // R/W1C, 1bit
    ULONG   RxSegment0;         // R/W1C, 1bit
    ULONG   RxSegment1;         // R/W1C, 1bit
    ULONG   ModemStatus;        // R/W1C, 1bit
    ULONG   RxSegmentOverrun;   // R/W1C, 1bit
    ULONG   UARTOverrun;        // R/W1C, 1bit
    
    ULONG   Rx0Ready;           // R, 1bit
    ULONG   Rx0LineError;       // R, 1bit
    ULONG   Rx0Timeout;         // R, 1bit
    
    ULONG   Rx1Ready;           // R, 1bit
    ULONG   Rx1LineError;       // R, 1bit
    ULONG   Rx1Timeout;         // R, 1bit
    
}EUARTDMAInterruptStatus, *PEUARTDMAInterruptStatus;

#pragma pack(push, old)
#pragma pack(1) // because DMA RxBuffer use this structure
typedef struct _EUARTCharAndStatus
{
    UCHAR       CharStatus;
    UCHAR       Char;
}EUARTCharAndStatus, *PEUARTCharAndStatus;
#pragma pack(pop, old)

//----
//  EUARTVolatileInfo
//  App may not use this structure.
typedef struct _EUARTVolatileInfo
{
    // volatile info
    ULONG                       NumberRxChar;
    
    EUARTCharAndStatus          CharAndStatus[256];
    //UCHAR                       RxChar[256];
    //UCHAR                       RxCharStatus[256];
    
    
    //EUARTLineStatus             sEUARTLineStatus;
    EUARTModemStatus            sEUARTModemStatus;
    
    EUARTDMAInterruptStatus     sEUARTDMAInterruptStatus;
    
    // debug info
}EUARTVolatileInfo, *PEUARTVolatileInfo;

#endif
